package com.tomas.ht_ydt.Adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_ydt.ClickItem_OutboundManual;
import com.tomas.ht_ydt.ListData.LabelItem_Outbound_list;
import com.tomas.ht_ydt.R;

import java.text.DecimalFormat;
import java.util.List;

public class OutboundManual_Adapter extends RecyclerView.Adapter<OutboundManual_Adapter.ViewHolder> {

    private List<LabelItem_Outbound_list> data;
    Context context;
    private ClickItem_OutboundManual onClickItem;
    DecimalFormat decimalFormat;

    public OutboundManual_Adapter(List<LabelItem_Outbound_list> data, Context context, ClickItem_OutboundManual onClickItem) {
        this.data = data;
        this.context = context;
        this.onClickItem = onClickItem;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_no, txt_lot_no, txt_location, txt_qty, txt_unit, txt_status;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (LinearLayout) itemview.findViewById(R.id.item_row);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_unit = (TextView)itemView.findViewById(R.id.txt_unit);
            txt_status = (TextView)itemView.findViewById(R.id.txt_status);
        }

    }

    @NonNull
    @Override
    public OutboundManual_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_label,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull OutboundManual_Adapter.ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,##0.00");
        final LabelItem_Outbound_list item = data.get(position);
        holder.txt_no.setText(item.getNo());
        holder.txt_lot_no.setText(item.getLot_no().trim());
        holder.txt_location.setText(item.getLast_location_id().trim());
//        holder.txt_qty.setText(item.getPick_qty()+"/"+item.getAct_stock_qty());
//        holder.txt_qty.setText(item.getPick_qty());
        holder.txt_qty.setText(decimalFormat.format(Float.parseFloat(item.getPick_qty())));
        holder.txt_unit.setText(item.getControl_unit().trim());
        String status = item.getStatus();
        holder.txt_status.setText(status);
        if (status.trim().equals("OK")){
            holder.layout.setBackgroundResource(R.color.color_green);
        }else{
            holder.layout.setBackgroundResource(R.color.color_yel);
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickItem.Item_Outbound_Manual(
                        item.getLabel_id(),
                        item.getPick_qty(),
                        item.getAct_stock_qty(),
                        item.getRemain_qty(),
                        item.getControl_unit());
            }
        });

    }



    @Override
    public int getItemCount() {
        return data.size();
    }
}
